/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.mna.items.ItemInit;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.Tags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class ChimeriteModifier
extends Modifier
implements ProjectileHitModifierHook {
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.PROJECTILE_HIT);
    }

    public List<ItemStack> processLoot(IToolStackView tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        Iterator<ItemStack> iterator = generatedLoot.iterator();
        float chance = (float)level * 0.2f;
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (!stack.m_204117_(Tags.Items.ORES)) continue;
            if (chance >= 1.0f) {
                generatedLoot.add(new ItemStack((ItemLike)ItemInit.CHIMERITE_GEM.get()));
                continue;
            }
            for (int i = 0; i < stack.m_41613_(); ++i) {
                if (!(RANDOM.nextFloat() < chance)) continue;
                generatedLoot.add(new ItemStack((ItemLike)ItemInit.CHIMERITE_GEM.get()));
            }
        }
        return generatedLoot;
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        Entity targetEntity = hit.m_82443_();
        if (!targetEntity.m_6084_() && attacker != null && target.m_21232_() == attacker) {
            float distance = targetEntity.m_20270_((Entity)attacker);
            float chance = distance / 10.0f * (float)modifier.getLevel();
            if (RANDOM.nextFloat() <= chance) {
                Item gem = (Item)ItemInit.CHIMERITE_GEM.get();
                targetEntity.m_19998_((ItemLike)gem);
            }
        }
        return false;
    }
}

